﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SWAT_Office_App
{
    public partial class Add_Hidden_Account_Form : Form
    {
        public Add_Hidden_Account_Form()
        {
            InitializeComponent();
            this.btn_Ok.Enabled = false;

            this.txt_AddHiddenAccount.TextChanged += new EventHandler(this.txt_TextChanged);
        }
        private void txt_TextChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Text.Length == 0)
                this.btn_Ok.Enabled = false;
            else
                this.btn_Ok.Enabled = true;
        }
        private void btn_Cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        private void btn_Ok_Click(object sender, EventArgs e)
        {
            bool error = false;
            // Checks if account already exists in the list of hidden accounts
            foreach (string hiddenUser in Settings_Form.hiddenAccounts)
            {
                if (this.txt_AddHiddenAccount.Text.ToLower() == hiddenUser.ToLower())
                {
                    MessageBox.Show("Account is already in the list of hidden accounts", "Error");
                    error = true;
                    this.txt_AddHiddenAccount.Text = "";
                    this.txt_AddHiddenAccount.Focus();
                }
            }
            if (error == false)
            {
                Settings_Form.hiddenAccounts.Add(txt_AddHiddenAccount.Text);
                this.Close();
            }
        }
    }
}
